//  -*- Mode: C++;  -*-
//  File: aggro.cc
//  Author: Dino B. 
//  Copyright (C) BlueG SoftWear 2000, DoggyConsults 2000
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION: Main -- Starting Point of Simulations
// *
// * CLASSES: Grid
// * 
// * RELATED PACKAGES: grid.cc
// *
// * HISTORY:
// * Created: Thu Mar 23 2000
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// include files
#include <stdio.h>
#include <stdlib.h>
#include <fstream.h>
#include <math.h>
#include <string.h>
#include "grid.h"
#include "macros.h"
#include "notice.h"

// constants
#define Q_T	0
#define BIN	1
#define AGG	2
#define FLD	3
#define CENTER	0

main(int argc, char **argv) 
{
	// variables
	Grid grd;
	int i, j, k, l, n, size, size2, pass;
	double val, mval, inst, aggt, remt, wexp, **filt, *buff;
	char bingrd[80], *p;

	// check command line
	if (argc != 8)
	{
		cerr << "Usage: " << argv[0] <<
			" <input grid> <square window size (cells)>" <<
			" <instability threshold (-log(q/t))>" <<
			" <aggregation threshold (%)>" <<
			" <removal threshold (%)>" <<
			" <weighing exponent>" <<
			" <number of passes>\n";
    		exit(1);
  	}


	// read grid
	cerr << "Reading input grid ...\n";
	if (!grd.readGrid(argv[1]))
		exit(1);

	// get and check command line parameters
    	if ((size = atoi(argv[2])) < 1 || size > min(grd.ydim, grd.ydim) || 
		!(size % 2))
    	{
                cerr << "Window size must be an odd number between 1 and " << 
			min(grd.ydim, grd.ydim) << "\n";
                exit(1);
        }
        if ((inst = atof(argv[3])) >= 0.0)
        {
                cerr << "Instability threshold must be less than 0\n";
                exit(1);
        }
        if ((aggt = atof(argv[4])) < 0.0 || aggt > 100.0)
        {
                cerr << "Aggregation threshold must be between 0% and 100%\n";
                exit(1);
        }
        if ((remt = atof(argv[5])) < 0.0 || remt > 100.0)
        {
                cerr << "Removal threshold must be must be between 0% and 100%\n";
                exit(1);
        }
        if ((wexp = atof(argv[6])) < 0.0)
        {
                cerr << "Weighing exponent must be greater or equal to 0\n";
                exit(1);
        }
        if ((pass = atoi(argv[7])) <= 0)
        {
                cerr << "The number of passes must be greater than 0\n";
                exit(1);
        }
	size2 = size >> 1;
 
	// allocate memory
	cerr << "Allocating memory ...\n";

	for (i = 0; i < FLD - 1; ++i)
	{
		if (!grd.addField())
		{
			cerr << "Memory allocation error\n";
			exit(1);
		}
	}

	// create binary grid
	cerr << "Creating binary grid ...\n";
	grd.mkBinary(inst, TRUE, Q_T, BIN);

	// construct output file name and save binary grid
	if ((p = strrchr(strcpy(bingrd, argv[1]), '.')) != NULL)
		*p = '\0';
	strcat(bingrd, ".bin");
	cerr << "Writing binary grid (" << bingrd << ") ...\n";
	grd.writeGrid(bingrd, BIN);

	// create filter
	cerr << "Creating filter:\n";
	if ((buff = (double *)malloc(size * size * sizeof(double))) == 
		(double *)NULL ||
		(filt = (double **)malloc(size * sizeof(double *))) == 
		(double **)NULL)
	{
		cerr << "Memory allocation error\n";
		exit(1);
	}
	for (i = 0, mval = 0.0; i < size; ++i)
	{
		*(filt + i) = buff + (i * size);
		for (j = 0; j < size; ++j)
		{
			if (i == size2 && j == size2)
				filt[i][j] = CENTER;
			else
				filt[i][j] = 
					1.0 / pow(sqrt(sqr(i - size2) + 
					sqr(j - size2)) * grd.spacing, wexp);
			mval += filt[i][j];
			cerr << filt[i][j] << " ";
		}
		cerr << "\n";
	}
	cerr << "Maximum value: " << mval << "\n";
	cerr << "Instability threshold: " << inst << "\n";
	cerr << "Aggregation threshold: " << aggt << "\n";
	cerr << "Removal threshold: " << remt << "\n";

	// passes loop
	for (n = 0; n < pass; ++n)
	{
		cerr << "Filtering (pass " << n + 1 << ") ...\n";

		// grid loop
		for (j = 0; j < grd.ydim; ++j)
		{
			for (i = 0; i < grd.xdim; ++i)
      	    		{
				if (!grd.isValue(i, j))
				{
					grd.at(i, j, AGG) = grd.nodata;
					continue;
				}

				// filter loop
				for (k = -size2, val = 0.0, mval = 0.0; k <= size2; ++k)
				{
					for (l = -size2; l <= size2; ++l)
      	          			{
						if (grd.isValue(i + k, j + l, BIN))
						{
							val += filt[k + size2][l + size2] *
								grd.at(i + k, j + l, BIN);
							mval += filt[k + size2][l + size2];
						}
                			}
        			}

				// express as percentage of max. value
				val *= (100 / mval);

// cerr << "i, j: " << i << "," << j << " val, mval: " << val << "," << mval << "\n";

				// aggro loop
				for (k = -size2; k <= size2; ++k)
				{
					for (l = -size2; l <= size2; ++l)
					{
						if (grd.isValue(i + k, j + l, BIN))
						{
							// check aggregation threshold
							if (val > aggt)
								grd.at(i + k, j + l, AGG) = TRUE;
							// check removal threshold
							else if (val < remt)
								grd.at(i + k, j + l, AGG) = FALSE;
							// leave as is
							else
								grd.at(i + k, j + l, AGG) =
									grd.at(i + k, j + l, BIN);
						}					
					}
				}				
			}
		}

		// prepare for next pass
		if (n < pass - 1)
		{
			cerr << "Initializing for pass " << n + 2 << " ...\n";
			grd.setValue(BIN, AGG);
		}
	}

	cerr << "Writing output grid ...\n";
	grd.coutGrid(AGG);

	return(0);
}
